/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.icon;

import com.google.common.base.Objects;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.IResourceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconProperties;
import dev.ftb.mods.ftblibrary.math.PixelBuffer;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ImageIcon
extends Icon
implements IResourceIcon {
    public static final class_2960 MISSING_IMAGE = new class_2960("ftblibrary", "textures/gui/missing_image.png");
    public final class_2960 texture;
    public float minU;
    public float minV;
    public float maxU;
    public float maxV;
    public double tileSize;
    public Color4I color;

    public ImageIcon(class_2960 tex) {
        this.texture = tex;
        this.minU = 0.0f;
        this.minV = 0.0f;
        this.maxU = 1.0f;
        this.maxV = 1.0f;
        this.tileSize = 0.0;
        this.color = Color4I.WHITE;
    }

    @Override
    public ImageIcon copy() {
        ImageIcon icon = new ImageIcon(this.texture);
        icon.minU = this.minU;
        icon.minV = this.minV;
        icon.maxU = this.maxU;
        icon.maxV = this.maxV;
        icon.tileSize = this.tileSize;
        return icon;
    }

    @Override
    protected void setProperties(IconProperties properties) {
        super.setProperties(properties);
        this.minU = (float)properties.getDouble("u0", this.minU);
        this.minV = (float)properties.getDouble("v0", this.minV);
        this.maxU = (float)properties.getDouble("u1", this.maxU);
        this.maxV = (float)properties.getDouble("v1", this.maxV);
        this.tileSize = properties.getDouble("tile_size", this.tileSize);
    }

    @Environment(value=EnvType.CLIENT)
    public void bindTexture() {
        class_1060 manager = class_310.method_1551().method_1531();
        class_1044 tex = manager.method_4619(this.texture);
        if (tex == null) {
            tex = new class_1049(this.texture);
            manager.method_4616(this.texture, tex);
        }
        RenderSystem.setShaderTexture((int)0, (int)tex.method_4624());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void draw(class_332 graphics, int x, int y, int w, int h) {
        this.bindTexture();
        if (this.tileSize <= 0.0) {
            GuiHelper.drawTexturedRect(graphics, x, y, w, h, this.color, this.minU, this.minV, this.maxU, this.maxV);
        } else {
            int r = this.color.redi();
            int g = this.color.greeni();
            int b = this.color.bluei();
            int a = this.color.alphai();
            Matrix4f m = graphics.method_51448().method_23760().method_23761();
            class_289 tesselator = class_289.method_1348();
            class_287 buffer = tesselator.method_1349();
            RenderSystem.setShader(class_757::method_34541);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
            buffer.method_22918(m, (float)x, (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913((float)((double)x / this.tileSize), (float)((double)(y + h) / this.tileSize)).method_1344();
            buffer.method_22918(m, (float)(x + w), (float)(y + h), 0.0f).method_1336(r, g, b, a).method_22913((float)((double)(x + w) / this.tileSize), (float)((double)(y + h) / this.tileSize)).method_1344();
            buffer.method_22918(m, (float)(x + w), (float)y, 0.0f).method_1336(r, g, b, a).method_22913((float)((double)(x + w) / this.tileSize), (float)((double)y / this.tileSize)).method_1344();
            buffer.method_22918(m, (float)x, (float)y, 0.0f).method_1336(r, g, b, a).method_22913((float)((double)x / this.tileSize), (float)((double)y / this.tileSize)).method_1344();
            tesselator.method_1350();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.texture, Float.valueOf(this.minU), Float.valueOf(this.minV), Float.valueOf(this.maxU), Float.valueOf(this.maxV)});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImageIcon) {
            ImageIcon img = (ImageIcon)o;
            return this.texture.equals((Object)img.texture) && this.minU == img.minU && this.minV == img.minV && this.maxU == img.maxU && this.maxV == img.maxV;
        }
        return false;
    }

    public String toString() {
        return this.texture.toString();
    }

    @Override
    public ImageIcon withColor(Color4I color) {
        ImageIcon icon = this.copy();
        icon.color = color;
        return icon;
    }

    @Override
    public ImageIcon withTint(Color4I c) {
        return this.withColor(this.color.withTint(c));
    }

    @Override
    public ImageIcon withUV(float u0, float v0, float u1, float v1) {
        ImageIcon icon = this.copy();
        icon.minU = u0;
        icon.minV = v0;
        icon.maxU = u1;
        icon.maxV = v1;
        return icon;
    }

    @Override
    public boolean hasPixelBuffer() {
        return true;
    }

    @Override
    @Nullable
    public PixelBuffer createPixelBuffer() {
        try {
            return PixelBuffer.from(((class_3298)class_310.method_1551().method_1478().method_14486(this.texture).orElseThrow()).method_14482());
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public double aspectRatio() {
        if (this.maxV == this.minV) {
            return 1.0;
        }
        return (this.maxU - this.minU) / (this.maxV - this.minV);
    }

    @Override
    public class_2960 getResourceLocation() {
        return this.texture;
    }
}

